/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.ModList;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import vazkii.botania.api.mana.ManaItemHandler;

public class ManaburnerModifier
extends Modifier {
    boolean enabled = ModList.get().isLoaded("botania");
    private static final int MANA_COST = 80;

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (this.enabled && isEffective && !tool.isBroken() && event.getEntityLiving() instanceof Player) {
            ItemStack toolStack = event.getEntityLiving().m_21205_();
            if (tool instanceof ToolStack) {
                toolStack = ((ToolStack)tool).createStack();
            }
            if (ManaItemHandler.instance().requestManaExactForTool(toolStack, (Player)event.getEntityLiving(), 80 * level, false)) {
                event.setNewSpeed(event.getNewSpeed() + 2.5f * (float)level * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED));
            }
        }
    }

    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
        if (this.enabled && context.isAOE() && context.isEffective() && !tool.isBroken() && context.getPlayer() != null) {
            ItemStack toolStack = context.getPlayer().m_21205_();
            if (tool instanceof ToolStack) {
                toolStack = ((ToolStack)tool).createStack();
            }
            ManaItemHandler.instance().requestManaExactForTool(toolStack, (Player)context.getPlayer(), 80 * level, true);
        }
    }

    public void addInformation(IToolStackView tool, int level, Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        this.addStatTooltip(tool, ToolStats.MINING_SPEED, TinkerTags.Items.HARVEST, 2.5f * (float)level, tooltip);
    }
}

